(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     19974,        766]*)
(*NotebookOutlinePosition[     20813,        793]*)
(*  CellTagsIndexPosition[     20769,        789]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.
Make modifications to any definition using commands in the Format menu.\
\>", 
  "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  CellBracketOptions->{"Color"->RGBColor[0.4, 0, 0.239994]},
  ScriptMinSize->9,
  Background->RGBColor[1, 0.960006, 0.900008]],

Cell[StyleData[All, "Presentation"],
  PageWidth->WindowWidth,
  CellBracketOptions->{"Color"->RGBColor[0.744411, 0.47155, 0.371542]},
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ShowCellLabel->False,
  ImageSize->{200, 200},
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellFrame->{{0, 0}, {0, 0.25}},
  CellMargins->{{18, 10}, {0, 20}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CellFrameMargins->6,
  CellFrameColor->GrayLevel[0],
  LineSpacing->{0.95, 0},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->36,
  FontWeight->"Bold",
  FontColor->RGBColor[0.4, 0, 0.239994]],

Cell[StyleData["Title", "Presentation"],
  CellMargins->{{20, 10}, {2, 20}},
  CellFrameMargins->5,
  FontColor->RGBColor[0.744411, 0.47155, 0.371542]],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{18, 30}, {0, 0}},
  CellFrameMargins->4,
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{20, 30}, {2, 10}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  CellFrameMargins->{{0, 4}, {8, 4}},
  LineSpacing->{1, 0},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->24],

Cell[StyleData["Subtitle", "Presentation"],
  CellMargins->{{20, 10}, {2, 10}}],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{18, 30}, {0, 10}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section 1"],
  CellFrame->{{0, 0}, {0, 3}},
  CellMargins->{{18, 10}, {10, 30}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{0, 4}, {8, 4}},
  CellFrameColor->RGBColor[0.4, 0, 0.239994],
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["Section 1", "Presentation"],
  CellMargins->{{20, 10}, {6, 30}},
  CellFrameMargins->5],

Cell[StyleData["Section 1", "Printout"],
  CellMargins->{{18, 30}, {4, 30}},
  CellFrameMargins->4,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{0, 0}, {0, 0.25}},
  CellMargins->{{18, 10}, {10, 30}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->4,
  CellFrameColor->RGBColor[0.4, 0, 0.239994],
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["Section", "Presentation"],
  CellMargins->{{20, 10}, {0, 30}}],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{18, 30}, {0, 30}},
  CellFrameMargins->5,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{38, 30}, {2, 20}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
  CellMargins->{{35, 30}, {0, 20}}],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{18, 30}, {0, 10}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{55, 30}, {4, 10}},
  CellGroupingRules->{"SectionGrouping", 60},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
  CellMargins->{{31, 30}, {0, 12}}],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{18, 30}, {0, 12}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{55, 10}, {6, 6}},
  TextJustification->1,
  LineSpacing->{1, 2},
  FontFamily->"Times"],

Cell[StyleData["Text", "Presentation"],
  CellMargins->{{20, 10}, {6, 6}},
  TextAlignment->Left,
  TextJustification->0,
  LineSpacing->{1.3, 0},
  FontSize->14],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Commentary"],
  CellMargins->{{55, 10}, {2, 6}},
  TextJustification->1,
  LineSpacing->{1, 2},
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->RGBColor[0, 0, 0.4]],

Cell[StyleData["Commentary", "Presentation"],
  CellMargins->{{60, 30}, {2, 6}},
  TextJustification->1,
  LineSpacing->{1.3, 0},
  FontSize->12],

Cell[StyleData["Commentary", "Printout"],
  CellMargins->{{18, 30}, {3, 0}},
  LineSpacing->{1, 3},
  FontFamily->"Times",
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellFrame->{{1, 1}, {0, 1}},
  CellMargins->{{55, 10}, {0, 0}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelPositioning->Automatic,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  FontSize->12,
  FontWeight->"Bold",
  Background->GrayLevel[0.966674]],

Cell[StyleData["Input", "Presentation"],
  CellMargins->{{60, 10}, {0, 10}},
  Background->GrayLevel[0.850004]],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{55, 10}, {0, 10}},
  FontSize->10,
  Background->GrayLevel[0.850004]]
}, Closed]],

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellFrame->{{1, 1}, {1, 0}},
  CellMargins->{{55, 10}, {15, 0}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  FontSize->12,
  Background->GrayLevel[0.850004]],

Cell[StyleData["Output", "Presentation"],
  CellMargins->{{60, Inherited}, {10, 0}}],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{55, Inherited}, {10, 0}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
  CellFrame->1,
  CellMargins->{{55, 10}, {15, 0}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelPositioning->Automatic,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  FontSize->12,
  FontWeight->"Bold",
  Background->GrayLevel[0.966674]],

Cell[StyleData["InputOnly", "Presentation"],
  CellMargins->{{60, Inherited}, {10, 10}}],

Cell[StyleData["InputOnly", "Printout"],
  CellMargins->{{55, Inherited}, {10, 10}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellFrame->{{1, 1}, {0, 0}},
  CellDingbat->"\[LongDash]",
  CellMargins->{{55, 10}, {0, 0}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontSlant->"Oblique",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[StyleData["Message", "Presentation"],
  CellMargins->{{60, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0}],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{55, Inherited}, {0, 0}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{55, 26}, {1, 6}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  TextAlignment->Left,
  FormatType->InputForm,
  StyleMenuListing->None,
  Background->GrayLevel[0.700008]],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{60, Inherited}, {10, 2}}],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{54, Inherited}, {2, 6}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellFrame->{{1, 1}, {0, 0}},
  CellMargins->{{55, 10}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->GrayLevel[0.850004]],

Cell[StyleData["Graphics", "Presentation"],
  CellMargins->{{60, Inherited}, {0, 0}},
  ImageMargins->{{10, 10}, {10, 10}}],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{55, Inherited}, {0, 0}},
  ImageSize->{0.0625, 0.0625}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontSlant->"Oblique",
  FontColor->RGBColor[0.6, 0, 0.6]],

Cell[StyleData["CellLabel", "Presentation"],
  CellMargins->{{18, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["CellLabel", "Printout"],
  CellMargins->{{0, Inherited}, {Inherited, Inherited}},
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Author"],
  CellMargins->{{20, 30}, {45, 5}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CellFrameMargins->{{0, 4}, {8, 4}},
  LineSpacing->{1, 0},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Author", "Presentation"],
  CellMargins->{{20, 30}, {45, 10}}],

Cell[StyleData["Author", "Printout"],
  CellMargins->{{18, 30}, {45, 5}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Abstract"],
  CellFrame->False,
  CellMargins->{{18, 140}, {4, 30}},
  LineSpacing->{0.9, 0},
  FontFamily->"Times",
  FontSize->12],

Cell[StyleData["Abstract", "Presentation"],
  CellFrame->True,
  CellMargins->{{20, 10}, {Inherited, 30}}],

Cell[StyleData["Abstract", "Printout"],
  LineSpacing->{1, 2},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
  CellMargins->{{55, 10}, {5, 3}},
  PageBreakAbove->False,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["Caption", "Presentation"],
  CellMargins->{{60, 65}, {6, 4}},
  FontSize->10],

Cell[StyleData["Caption", "Printout"],
  CellMargins->{{55, 55}, {5, 4}},
  LineSpacing->{1, 2},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
  CellMargins->{{24, 40}, {6, 6}},
  TextJustification->1,
  LineSpacing->{1, 0},
  FontFamily->"Times"],

Cell[StyleData["Reference", "Presentation"],
  CellMargins->{{20, 40}, {Inherited, 6}},
  TextJustification->0,
  LineSpacing->{1, 4},
  FontSize->12],

Cell[StyleData["Reference", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
  CellFrame->{{1, 1}, {0, 0}},
  CellMargins->{{55, Inherited}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  ShowCellLabel->False,
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->GrayLevel[0.850004]],

Cell[StyleData["PictureGroup", "Presentation"],
  CellMargins->{{60, Inherited}, {0, 0}},
  ImageMargins->{{10, 10}, {10, 10}}],

Cell[StyleData["PictureGroup", "Printout"],
  CellMargins->{{55, Inherited}, {0, 0}},
  ImageSize->{0.0625, 0.0625}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{55, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  ScriptLevel->0,
  SingleLetterItalics->True,
  StyleMenuListing->None,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Presentation"],
  CellMargins->{{60, 10}, {Inherited, 6}},
  LineSpacing->{1, 5}],

Cell[StyleData["DisplayFormula", "Printout"],
  CellMargins->{{18, 4}, {4, 4}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChemicalFormula"],
  CellMargins->{{55, 10}, {Inherited, 0}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  TextJustification->1,
  AutoSpacing->False,
  ScriptLevel->1,
  ScriptBaselineShifts->{0.6, Automatic},
  SingleLetterItalics->False,
  ZeroWidthTimes->True],

Cell[StyleData["ChemicalFormula", "Presentation"],
  CellMargins->{{60, 10}, {Inherited, 6}}],

Cell[StyleData["ChemicalFormula", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellMargins->{{55, 10}, {Inherited, 0}},
  CellHorizontalScrolling->True,
  FontFamily->"Courier"],

Cell[StyleData["Program", "Presentation"],
  CellMargins->{{60, 10}, {Inherited, 6}}],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->9.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Automatic Numbering", "Section"],

Cell["\<\
The following styles are useful for numbered equations, figures, \
etc.  They automatically give the cell a FrameLabel containing a reference to \
a particular counter, and also increment that counter.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
  CellMargins->{{55, 85}, {Inherited, Inherited}},
  CellFrameLabels->{{None, Cell[ 
          TextData[ {"(", 
            CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
  DefaultFormatType->DefaultInputFormatType,
  CounterIncrements->"NumberedEquation",
  FormatTypeAutoConvert->False,
  FontFamily->"Times"],

Cell[StyleData["NumberedEquation", "Presentation"],
  CellMargins->{{60, 10}, {Inherited, 6}},
  LineSpacing->{1, 0}],

Cell[StyleData["NumberedEquation", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedFigure"],
  CellMargins->{{55, 95}, {Inherited, Inherited}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Figure ", 
            CounterBox[ "NumberedFigure"]}], FontWeight -> "Bold"], None}},
  CounterIncrements->"NumberedFigure",
  FormatTypeAutoConvert->False,
  FontFamily->"Times"],

Cell[StyleData["NumberedFigure", "Presentation"],
  CellMargins->{{60, 80}, {Inherited, 6}},
  LineSpacing->{1, 0}],

Cell[StyleData["NumberedFigure", "Printout"],
  CellMargins->{{18, 80}, {4, 4}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedTable"],
  CellMargins->{{55, 95}, {Inherited, Inherited}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Table ", 
            CounterBox[ "NumberedTable"]}], FontWeight -> "Bold"], None}},
  TextAlignment->Center,
  CounterIncrements->"NumberedTable",
  FormatTypeAutoConvert->False,
  FontFamily->"Times"],

Cell[StyleData["NumberedTable", "Presentation"],
  CellMargins->{{60, 80}, {Inherited, 6}},
  LineSpacing->{1, 0}],

Cell[StyleData["NumberedTable", "Printout"],
  CellMargins->{{18, 80}, {4, 4}},
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["PageNumber"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Bold"],

Cell[StyleData["Footer"],
  TextAlignment->Center,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{495, 309},
WindowMargins->{{8, Automatic}, {Automatic, 2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 52, "Subtitle"],
Cell[1771, 53, 193, 5, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 62, 42, 0, 50, "Section"],
Cell[2034, 64, 185, 4, 52, 31, 0, "StyleData", "All", "Working"],
Cell[2222, 70, 154, 3, 36, 36, 0, "StyleData", "All", "Presentation"],
Cell[2379, 75, 153, 4, 36, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2569, 84, 35, 0, 30, "Section"],
Cell[2607, 86, 101, 3, 30, "Text"],
Cell[2711, 91, 426, 11, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3174, 107, 38, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[3237, 111, 421, 12, 78, 24, 0, "StyleData", "Title", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[3661, 125, 151, 3, 79, 40, 0, "StyleData", "Title", "Presentation"],
Cell[3815, 130, 110, 3, 45, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3962, 138, 308, 8, 55, 27, 0, "StyleData", "Subtitle", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[4273, 148, 79, 1, 53, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[4355, 151, 91, 2, 44, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4483, 158, 413, 11, 63, 28, 0, "StyleData", "Section 1", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[4899, 171, 103, 2, 78, 44, 0, "StyleData", "Section 1", "Presentation"],
Cell[5005, 175, 115, 3, 71, 40, 0, "StyleData", "Section 1", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5157, 183, 399, 11, 60, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[5559, 196, 78, 1, 68, 42, 0, "StyleData", "Section", "Presentation"],
Cell[5640, 199, 113, 3, 65, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5790, 207, 312, 9, 44, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[6105, 218, 81, 1, 50, 45, 0, "StyleData", "Subsection", "Presentation"],
Cell[6189, 221, 93, 2, 39, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6319, 228, 277, 8, 45, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[6599, 238, 84, 1, 41, 48, 0, "StyleData", "Subsubsection", 
"Presentation"],
Cell[6686, 241, 96, 2, 38, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6831, 249, 39, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[6895, 253, 128, 4, 40, 23, 0, "StyleData", "Text", "All"],
Cell[7026, 259, 162, 5, 43, 39, 0, "StyleData", "Text", "Presentation"],
Cell[7191, 266, 108, 3, 35, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7336, 274, 188, 6, 41, 29, 0, "StyleData", "Commentary", "All"],
Cell[7527, 282, 145, 4, 37, 45, 0, "StyleData", "Commentary", "Presentation"],

Cell[7675, 288, 138, 4, 30, 41, 0, "StyleData", "Commentary", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7862, 298, 42, 0, 30, "Section"],
Cell[7907, 300, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[8180, 309, 531, 16, 46, 24, 0, "StyleData", "Input", "All"],
Cell[8714, 327, 111, 2, 56, 40, 0, "StyleData", "Input", "Presentation"],
Cell[8828, 331, 123, 3, 53, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],
Cell[8966, 337, 375, 12, 45, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],

Cell[CellGroupData[{
Cell[9366, 353, 483, 14, 60, 25, 0, "StyleData", "Output", "All"],
Cell[9852, 369, 84, 1, 55, 41, 0, "StyleData", "Output", "Presentation"],
Cell[9939, 372, 96, 2, 54, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10072, 379, 521, 16, 74, 28, 0, "StyleData", "InputOnly", "All"],
Cell[10596, 397, 88, 1, 67, 44, 0, "StyleData", "InputOnly", "Presentation"],
Cell[10687, 400, 100, 2, 64, 40, 0, "StyleData", "InputOnly", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10824, 407, 574, 18, 40, 26, 0, "StyleData", "Message", "All",
  StyleMenuListing->None],
Cell[11401, 427, 123, 2, 28, 42, 0, "StyleData", "Message", "Presentation"],
Cell[11527, 431, 95, 2, 24, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11659, 438, 480, 14, 57, 24, 0, "StyleData", "Print", "All",
  StyleMenuListing->None],
Cell[12142, 454, 83, 1, 56, 40, 0, "StyleData", "Print", "Presentation"],
Cell[12228, 457, 94, 2, 51, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12359, 464, 450, 13, 56, 27, 0, "StyleData", "Graphics", "All",
  StyleMenuListing->None],
Cell[12812, 479, 123, 2, 44, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[12938, 483, 112, 2, 44, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13087, 490, 157, 5, 44, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[13247, 497, 102, 1, 36, 44, 0, "StyleData", "CellLabel", "Presentation"],

Cell[13352, 500, 112, 2, 32, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13513, 508, 32, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[13570, 512, 329, 9, 80, 25, 0, "StyleData", "Author", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[13902, 523, 78, 1, 86, 41, 0, "StyleData", "Author", "Presentation"],
Cell[13983, 526, 73, 1, 81, 37, 0, "StyleData", "Author", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14093, 532, 148, 5, 36, 27, 0, "StyleData", "Abstract", "All"],
Cell[14244, 539, 106, 2, 78, 43, 0, "StyleData", "Abstract", "Presentation"],
Cell[14353, 543, 78, 2, 61, 39, 0, "StyleData", "Abstract", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14468, 550, 128, 4, 35, 26, 0, "StyleData", "Caption", "All"],
Cell[14599, 556, 93, 2, 37, 42, 0, "StyleData", "Caption", "Presentation"],
Cell[14695, 560, 111, 3, 33, 38, 0, "StyleData", "Caption", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14843, 568, 133, 4, 38, 28, 0, "StyleData", "Reference", "All"],
Cell[14979, 574, 150, 4, 40, 44, 0, "StyleData", "Reference", "Presentation"],

Cell[15132, 580, 89, 2, 34, 40, 0, "StyleData", "Reference", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15258, 587, 340, 9, 48, 31, 0, "StyleData", "PictureGroup", "All",
  StyleMenuListing->None],
Cell[15601, 598, 127, 2, 44, 47, 0, "StyleData", "PictureGroup", 
"Presentation"],
Cell[15731, 602, 116, 2, 44, 43, 0, "StyleData", "PictureGroup", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15896, 610, 43, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[15964, 614, 298, 7, 36, 33, 0, "StyleData", "DisplayFormula", "All",
  StyleMenuListing->None],
Cell[16265, 623, 115, 2, 38, 49, 0, "StyleData", "DisplayFormula", 
"Presentation"],
Cell[16383, 627, 79, 1, 36, 45, 0, "StyleData", "DisplayFormula", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[16499, 633, 315, 9, 36, 34, 0, "StyleData", "ChemicalFormula", "All"],
Cell[16817, 644, 93, 1, 38, 50, 0, "StyleData", "ChemicalFormula", 
"Presentation"],
Cell[16913, 647, 119, 3, 35, 46, 0, "StyleData", "ChemicalFormula", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[17069, 655, 127, 3, 36, 26, 0, "StyleData", "Program", "All"],
Cell[17199, 660, 85, 1, 38, 42, 0, "StyleData", "Program", "Presentation"],
Cell[17287, 663, 112, 3, 35, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[17448, 672, 49, 0, 30, "Section"],
Cell[17500, 674, 225, 4, 62, "Text"],

Cell[CellGroupData[{
Cell[17750, 682, 357, 8, 36, 35, 0, "StyleData", "NumberedEquation", "All",
  CounterIncrements->"NumberedEquation"],
Cell[18110, 692, 117, 2, 38, 51, 0, "StyleData", "NumberedEquation", 
"Presentation"],
Cell[18230, 696, 96, 2, 32, 47, 0, "StyleData", "NumberedEquation", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[18363, 703, 329, 7, 65, 33, 0, "StyleData", "NumberedFigure", "All",
  CounterIncrements->"NumberedFigure"],
Cell[18695, 712, 115, 2, 57, 49, 0, "StyleData", "NumberedFigure", 
"Presentation"],
Cell[18813, 716, 95, 2, 48, 45, 0, "StyleData", "NumberedFigure", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[18945, 723, 350, 8, 65, 32, 0, "StyleData", "NumberedTable", "All",
  CounterIncrements->"NumberedTable"],
Cell[19298, 733, 114, 2, 57, 48, 0, "StyleData", "NumberedTable", 
"Presentation"],
Cell[19415, 737, 94, 2, 48, 44, 0, "StyleData", "NumberedTable", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19558, 745, 49, 0, 30, "Section"],
Cell[19610, 747, 93, 3, 34, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[19706, 752, 119, 4, 36, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None],
Cell[19828, 758, 118, 4, 34, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

